// ------------------------------------
//   Desktop interface library header
//       OBLdos.h  Version 1.0
//    by: Harry Konstas March 20/2000
// ------------------------------------

#include "OBL.h"
#include "FfsLib.h"

// translation
#define strlen StrLen
#define strstr StrStr
#define strcmp StrCompare
#define strcpy StrCopy
#define strcat StrCat
#define strupr UpperCase
#define sprintf StrPrintF
#define malloc MemPtrNew
#define free MemPtrFree
#define fabs AbsFloat
#define atof AtoFloat
#define ftoa FloatToA
#define atol StrAToI

#define MAXFD 60

typedef enum {
  STR=1,
  CFG
}RSC_TYPE;

typedef enum {
  _ESC=1201,_OK,
  _F1,_F2,_F3,_F4,_F5,
  _F6,_F7,_F8,_F9,_F10,_ENTER
}VKEYS;

typedef struct {
  int xp;
  int yp;
  int wd;
  int ht;
}WND;
typedef WND * Window;

typedef struct SFORM {
  int      nf;
  Window   wnd;
  int	 wx;
  int	 wy;
  int	 ww;
  int	 wh;
  int      handled;
  char     rsc[40];
  char	 protect[MAXFD];
  int      x1[MAXFD];
  int      x2[MAXFD];
  int      y[MAXFD];
  char	 *buffer[MAXFD];
} FORM;


// ------------------------------------ 
//             PROTOTYPES
// ------------------------------------
 
void Beep(void);
void AppLaunch(char *fname);

int CheckPrinter(void);
int SendPrinter(char *s);

void Alert(int rscnum);
void FatalExit(char *msg);
void SendScreen(char *s);
void WaitMsg(void);
void clrscr(void);

int  k_getkey(void);
int  GetInput(char *title,char *buffer);
char *getpass(char *prompt);
char *GetDate(char *buffer);

char *itoa(int v,char *buffer,int base);
int  atoi(char *buffer);
char *ltoa(long v,char *buffer,int base);

void EditColors(void);
void ShowColors(void);

int open(char *fname, int flags, int mode);
int close(int h);
int read(int h,void *buf,int size);
int write(int h,void *buf,int size);
long lseek(int h,long offset,int origin);
int remove(char *fname);
int rename(char *oldname,char *newname);

Window w_open(int X,int Y,int W,int H);
void w_close(Window w);
void printw(Window w,int x,int y,char *text);
void w_lineh(Window w,char t,int cstart,int cend,int r);
void w_linev(Window w,char t,int rstart,int rend,int c);

FORM *OpenForm(char *rscname);
int  HandleForm(FORM *pFrm);
void CloseForm(FORM *pFrm);
void ProtectField(FORM *pFrm, int Item, int status);
char *GetField(FORM *pFrm, int Item, char *buffer);
void SetField(FORM *pFrm, int Item, char *string);

void SetResource(char *fname);
int  GetChoice(char *menuname);
char *GetResource(int type, int id, char *s);

